<?php
/**
 * Theme Metabox Options
 * @package ehome
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {

    $allowed_html = ehome()->kses_allowed_html(array('mark'));

    $prefix = 'ehome';

    /*-------------------------------------
        Post Format Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_post_video_options', array(
        'title' => esc_html__('Video Post Format Options', 'ehome'),
        'post_type' => 'post',
        'post_formats' => 'video'
    ));
    CSF::createSection($prefix . '_post_video_options', array(
        'fields' => array(
            array(
                'id' => 'video_url',
                'type' => 'text',
                'title' => esc_html__('Enter Video URL', 'ehome'),
                'desc' => wp_kses(__('enter <mark>video url</mark> to show in frontend', 'ehome'), $allowed_html)
            )
        )
    ));
    CSF::createMetabox($prefix . '_post_gallery_options', array(
        'title' => esc_html__('Gallery Post Format Options', 'ehome'),
        'post_type' => 'post',
        'post_formats' => 'gallery'
    ));
    CSF::createSection($prefix . '_post_gallery_options', array(
        'fields' => array(
            array(
                'id' => 'gallery_images',
                'type' => 'gallery',
                'title' => esc_html__('Select Gallery Photos', 'ehome'),
                'desc' => wp_kses(__('select <mark>gallery photos</mark> to show in frontend', 'ehome'), $allowed_html)
            )
        )
    ));

    /*-------------------------------------
      Page Container Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_page_container_options', array(
        'title' => esc_html__('Page Options', 'ehome'),
        'post_type' => array('page'),
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Layout & Colors', 'ehome'),
        'icon' => 'fa fa-columns',
        'fields' => Ehome_Group_Fields::page_layout()
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Header Footer & Breadcrumb', 'ehome'),
        'icon' => 'fa fa-header',
        'fields' => Ehome_Group_Fields::Page_Container_Options('header_options')
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Width & Padding', 'ehome'),
        'icon' => 'fa fa-file-o',
        'fields' => Ehome_Group_Fields::Page_Container_Options('container_options')
    ));
    //	Service Meta Box
    CSF::createMetabox($prefix . '_service_options', array(
        'title' => esc_html__('Service Options', 'ehome'),
        'post_type' => 'service',
    ));
    CSF::createSection($prefix . '_service_options', array(
        'fields' => array(
            array(
                'id' => 'service_icon',
                'type' => 'media',
                'title' => esc_html__('Icon', 'ehome'),
                'desc' => wp_kses(__('Select Your Icon', 'ehome'), $allowed_html)
            ),
            array(
                'id' => 'service_icon_shape',
                'type' => 'media',
                'title' => esc_html__('Icon Shape', 'ehome'),
                'desc' => wp_kses(__('Select Your Icon Shape', 'ehome'), $allowed_html)
            ),
            array(
                'id' => 'service_icon_shape_2',
                'type' => 'media',
                'title' => esc_html__('Icon Shape 2', 'ehome'),
                'desc' => wp_kses(__('Select Your Icon Shape 2', 'ehome'), $allowed_html)
            ),
            array(
                'id' => 'service_line_shape',
                'type' => 'media',
                'title' => esc_html__('Line Shape', 'ehome'),
                'desc' => wp_kses(__('Select Your Shape', 'ehome'), $allowed_html)
            ),
            array(
                'id' => 'service_content',
                'type' => 'textarea',
                'title' => esc_html__('service content', 'ehome'),
                'desc' => wp_kses(__('Select Your service content', 'ehome'), $allowed_html)
            )
        )
    ));

    /*-------------------------------------
     Team Options
    -------------------------------------*/
    
    CSF::createMetabox($prefix . '_team_options', array(
        'title' => esc_html__('Team Options', 'ehome'),
        'post_type' => array('team'),
        'priority' => 'high'
    ));
    CSF::createSection($prefix . '_team_options', array(
        'title' => esc_html__('Team Info', 'ehome'),
        'id' => 'ehome-info',
        'fields' => array(
            array(
                'id' => 'team_shape',
                'type' => 'media',
                'title' => esc_html__('Shape Image', 'ehome'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> shape image</mark> here', 'ehome'), $allowed_html),
            ),
            array(
                'id' => 'team_shape_2',
                'type' => 'media',
                'title' => esc_html__('Background Shape', 'ehome'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> shape image</mark> here', 'ehome'), $allowed_html),
            ),
            array(
                'id' => 'designation',
                'type' => 'text',
                'title' => esc_html__('Designation', 'ehome'),
            ),
            array(
                'id' => 'team_content',
                'type' => 'textarea',
                'title' => esc_html__('Team content', 'ehome'),
                'desc' => wp_kses(__('Write Your content', 'ehome'), $allowed_html)
            )
        )
    ));
    CSF::createSection($prefix . '_team_options', array(
        'title' => esc_html__('Social Info', 'ehome'),
        'id' => 'social-info',
        'fields' => array(
            array(
                'id' => 'social-icons',
                'type' => 'repeater',
                'title' => esc_html__('Social Info', 'ehome'),
                'fields' => array(
                    array(
                        'id' => 'icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'ehome'),
                        'default' => 'fa fa-facebook-f'

                    ),
                    array(
                        'id' => 'url',
                        'type' => 'text',
                        'title' => esc_html__('URL', 'ehome')
                    ),

                ),
            ),
        )
    ));

    //	Project Meta Box
    CSF::createMetabox($prefix . '_project_options', array(
        'title' => esc_html__('Project Options', 'ehome'),
        'post_type' => 'project',
    ));

    CSF::createSection($prefix . '_project_options', array(
        'fields' => array(
            array(
                'id' => 'project_icon',
                'type' => 'text',
                'title' => esc_html__('Project Icon', 'ehome'),
                'desc' => wp_kses(__('Write your Project Icon Text', 'ehome'), $allowed_html)
            ),
            array(
                'id' => 'project_subtitle',
                'type' => 'text',
                'title' => esc_html__('Project Subtitle', 'ehome'),
                'desc' => wp_kses(__('Write your Project Subtitle', 'ehome'), $allowed_html)
            ),
            array(
                'id' => 'project_content',
                'type' => 'textarea',
                'title' => esc_html__('Project content', 'ehome'),
                'desc' => wp_kses(__('Write your Project content', 'ehome'), $allowed_html)
            ),
        )
    ));

    //	Product Meta Box
    CSF::createMetabox($prefix . '_product_options', array(
        'title' => esc_html__('Product Options', 'ehome'),
        'post_type' => 'product',
    ));
    CSF::createSection($prefix . '_product_options', array(
        'fields' => array(
            array(
                'id' => 'product_audio_img',
                'type' => 'media',
                'title' => esc_html__('Product audio image', 'ehome'),
            ),
            array(
                'id' => 'product_audio_list',
                'type' => 'text',
                'title' => esc_html__('Product audio url', 'ehome'),
                'default' => esc_html__('http://physical-authority.surge.sh/music/2.mp3', 'ehome'),
            ),
            array(
                'id' => 'product_subtitle',
                'type' => 'text',
                'title' => esc_html__('Product Subtitle', 'ehome'),
                'default' => esc_html__('Ray studio', 'ehome'),
            ),
            array(
                'id' => 'download_text',
                'type' => 'text',
                'title' => esc_html__('download text', 'ehome'),
                'default' => esc_html__('Download: 2.4K', 'ehome'),
            ),
        )
    ));

    //	Courses Meta Box
    CSF::createMetabox($prefix . '_courses_options', array(
        'title' => esc_html__('Courses Options', 'ehome'),
        'post_type' => 'courses',
    ));

    CSF::createSection($prefix . '_courses_options', array(
        'title' => esc_html__('Social Info', 'ehome'),
        'id' => 'social-info',
        'fields' => array(
            array(
                'id' => 'course_start_date_option',
                'type' => 'text',
                'title' => esc_html__('Start From', 'ehome'),
                'default' => esc_html__('Thursday, Nov 4, 2023', 'ehome'),
            ),
            array(
                'id' => 'study-option',
                'type' => 'repeater',
                'title' => esc_html__('Study Options', 'ehome'),
                'fields' => array(

                    array(
                        'id' => 'qualification',
                        'type' => 'text',
                        'title' => esc_html__('Qualification', 'ehome'),
                        'default' => esc_html__('Bachelor of Aviation (Hons)', 'ehome'),
                    ),
                    array(
                        'id' => 'length',
                        'type' => 'text',
                        'title' => esc_html__('Length', 'ehome'),
                        'default' => esc_html__('9 months full time', 'ehome'),
                    ),
                    array(
                        'id' => 'code',
                        'type' => 'text',
                        'title' => esc_html__('Code', 'ehome'),
                        'default' => esc_html__('ba1x', 'ehome'),
                    ),
                ),
            ),
            array(
                'id' => 'course_module_option',
                'type' => 'text',
                'title' => esc_html__('Course Module Title', 'ehome'),
                'default' => esc_html__('Download full course Module', 'ehome'),
            ),
            array(
                'id' => 'course_module_button_title',
                'type' => 'text',
                'title' => esc_html__('Course Module Button Title', 'ehome'),
                'default' => esc_html__('Download', 'ehome'),
            ),
            array(
                'id' => 'course_module_button_url',
                'type' => 'text',
                'title' => esc_html__('Course Module Button URL', 'ehome'),
                'default' => esc_html__('#', 'ehome'),
            ),
        )
    ));
}//endif