<?php
/**
 * Theme Social Share Widget
 * @package Ehome
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('ehome_social_share_widget', array(
        'title' => esc_html__('Ehome: Social Share', 'ehome-core'),
        'classname' => 'ehome-social-share-about',
        'description' => esc_html__('Display Social Share widget', 'ehome-core'),
        'fields' => array(
            array(
                'id' => 'heading',
                'type' => 'text',
                'title' => esc_html__('Enter Your Header Title', 'ehome-core'),
                'default' => esc_html__('Never Miss News', 'ehome-core')
            ),
            array(
                'id' => 'ehome-social-icon-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Icon', 'ehome-core'),
                'fields' => array(
                    array(
                        'id' => 'ehome-social-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'ehome-core'),
                        'default' => 'fab fa-facebook'
                    ),
                    array(
                        'id' => 'ehome-social-text',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Ulr', 'ehome-core'),
                        'default' => '#'
                    ),
                ),
            ),
        )
    ));


    if (!function_exists('ehome_social_share_widget')) {
        function ehome_social_share_widget($args, $instance)
        {

            echo $args['before_widget'];
            

            $heading_title = $instance['heading'] ?? '';
            $socialIcon = is_array($instance['ehome-social-icon-repeater']) && !empty($instance['ehome-social-icon-repeater']) ? $instance['ehome-social-icon-repeater'] : [];


            ?>
            <div class="social-share-widget">
                <h4 class="widget-headline"><?php echo esc_html($heading_title); ?></h4>
                <ul class="social-icon style-03">
                    <?php
                    foreach ($socialIcon as $icon) {
                        printf('<li><a href="%2$s"><i class="%1$s"></i></a></li>', esc_html($icon['ehome-social-icon']), esc_url($icon['ehome-social-text']));
                    };
                    ?>
                </ul>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>