<?php
/**
 * Theme File Download Widget
 * @package Ehome
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('ehome_file_download_widget', array(
        'title' => esc_html__('Ehome: File Download', 'ehome-core'),
        'classname' => 'ehome-widget-file-download',
        'description' => esc_html__('Display File Download widget', 'ehome-core'),
        'fields' => array(
            array(
                'id' => 'title',
                'type' => 'text',
                'title' => esc_html__('Title', 'Ehome-core'),
                'default' => esc_html__('Download', 'ehome-core')
            ),

            array(
                'id' => 'ehome-file-download-repeater',
                'type' => 'repeater',
                'title' => esc_html__('File Download', 'ehome-core'),
                'fields' => array(
                    array(
                        'id' => 'ehome-file-download',
                        'type' => 'media',
                        'title' => esc_html__('File', 'ehome-core'),
                    ),
                    array(
                        'id' => 'ehome-file-download-text',
                        'type' => 'text',
                        'title' => esc_html__('File Text', 'ehome-core'),
                        'default' => esc_html__('Company Profile', 'ehome-core')
                    ),

                ),
            ),
        )
    ));


    if (!function_exists('ehome_file_download_widget')) {
        function ehome_file_download_widget($args, $instance)
        {

            echo $args['before_widget'];

            $title = $instance['title'] ?? '';
            $file_download = is_array($instance['ehome-file-download-repeater']) && !empty($instance['ehome-file-download-repeater']) ? $instance['ehome-file-download-repeater'] : [];


            ?>
            <div class="widget_download">
                <h5 class="widget-headline style-01"><?php echo esc_html($title); ?></h5>               
                <ul>
                    <?php
                        foreach ($file_download as $file) {
                            echo '<li class="mb-0 mt-0">
                                <a download href="'.$file['ehome-file-download']['url'].'">
                                    ' . $file['ehome-file-download-text'] . '
                                    <i class="fa fa-angle-double-right"></i>
                                </a>
                            </li>';
                        };
                    ?>
                </ul>
            </div>
            <?php

            echo $args['after_widget'];

        }
    }

}

?>