<?php
namespace Elementor;

/**
 * Elementor Widget
 * @package Ehome
 * @since 1.0.0
 */ 
 
class Project_Info extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'ehome-project-info-widget';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Project Info', 'ehome-core' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-flash';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories()
    {
        return ['ehome_widgets'];
    }
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// Tab Start - 1

		$this->start_controls_section(
			'project_info',
			[
				'label' => esc_html__( 'Project Info', 'ehome-core' ),
			]
		);	
	
		$this->add_control(
				'title',
				[
					'label'       => __( 'Title', 'ehome-core' ),
					'type'        => Controls_Manager::TEXTAREA,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'Enter your title', 'ehome-core' ),
				]
			);

		$this->end_controls_section();

		// Tab Start - 2

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Block', 'ehome-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
		  'repeat', 
			[
				'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
				'default' => 
					[
						['block_title' => esc_html__('Hello World', 'ehome-core')],
					],
				'fields' => 
					[	

						'block_title' =>
						[
							'name' => 'block_title',
							'label' => esc_html__('Title', 'ehome-core'),
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'ehome-core')
						],
						
					],
				'title_field' => '{{block_title}}',
			 ]
	);
		
		
	$this->end_controls_section();	

	
		}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>
		
	
	<div class="project-details-wrapper">
		<div class="project-details-items">
			<div class="project-details-content mt-0">
				<div class="project-infor-wrapper p-0">
					<div class="project-nformation">
						<h4><?php echo $settings['title'];?></h4>
						<ul>
						<?php foreach($settings['repeat'] as $item):?>
							<li>
								<?php echo wp_kses($item['block_title'], $allowed_tags);?>
							</li>
							<?php endforeach; ?>
						</ul>
					</div>
				</div>
			</div>
		</div>   
	</div>
             
		<?php 
	}


}

Plugin::instance()->widgets_manager->register_widget_type(new Project_Info());