<?php
/**
 * Theme functions & definitations
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package ehome
 */

/**
 * Define Theme Folder Path & URL Constant
 * @package ehome
 * @since 1.0.0
 */

define('EHOME_THEME_ROOT', get_template_directory());
define('EHOME_THEME_ROOT_URL', get_template_directory_uri());
define('EHOME_INC', EHOME_THEME_ROOT . '/inc');
define('EHOME_THEME_SETTINGS', EHOME_INC . '/theme-settings');
define('EHOME_THEME_SETTINGS_IMAGES', EHOME_THEME_ROOT_URL . '/inc/theme-settings/images');
define('EHOME_TGMA', EHOME_INC . '/plugins/tgma');
define('EHOME_DYNAMIC_STYLESHEETS', EHOME_INC . '/theme-stylesheets');
define('EHOME_CSS', EHOME_THEME_ROOT_URL . '/assets/css');
define('EHOME_JS', EHOME_THEME_ROOT_URL . '/assets/js');
define('EHOME_ASSETS', EHOME_THEME_ROOT_URL . '/assets');
define('EHOME_DEV', true);


/**
 * Theme Initial File
 * @package ehome
 * @since 1.0.0
 */
if (file_exists(EHOME_INC . '/theme-init.php')) {
    require_once EHOME_INC . '/theme-init.php';
}


/**
 * Codester Framework Functions
 * @package ehome
 * @since 1.0.0
 */
if (file_exists(EHOME_INC . '/theme-cs-function.php')) {
    require_once EHOME_INC . '/theme-cs-function.php';
}


/**
 * Theme Helpers Functions
 * @package ehome
 * @since 1.0.0
 */
if (file_exists(EHOME_INC . '/theme-helper-functions.php')) {

    require_once EHOME_INC . '/theme-helper-functions.php';
    if (!function_exists('ehome')) {
        function ehome()
        {
            return class_exists('Ehome_Helper_Functions') ? new Ehome_Helper_Functions() : false;
        }
    }
}
/**
 * Nav menu fallback function
 * @since 1.0.0
 */
if (is_user_logged_in()) {
    function ehome_theme_fallback_menu()
    {
        get_template_part('template-parts/default', 'menu');
    }
}

// theme-color

if (file_exists(EHOME_INC . '/theme-color.php')) {
    require_once EHOME_INC . '/theme-color.php';
}



// register_block_style

function ehome_register_block_styles() {
    register_block_style(
        'core/paragraph',
        array(
            'name'  => 'fancy-paragraph',
            'label' => __( 'Fancy Paragraph', 'ehome' ),
        )
    );
}
add_action( 'init', 'ehome_register_block_styles' );


// register_block_pattern

function ehome_register_block_patterns() {
    register_block_pattern(
        'ehome/hero-section',
        array(
            'title'       => __( 'Hero Section', 'ehome' ),
            'description' => _x( 'A custom hero section with image and text', 'Block pattern description', 'ehome' ),
            'content'     => '<!-- wp:paragraph --><p>Your content here...</p><!-- /wp:paragraph -->',
        )
    );
}
add_action( 'init', 'ehome_register_block_patterns' );


// custom-header

function ehome_custom_header_setup() {
    add_theme_support( 'custom-header', array(
        'default-image' => get_template_directory_uri() . '/inc/theme-settings/images/header/00.png',
        'width'         => 1000,
        'height'        => 250,
        'flex-width'    => true,
        'flex-height'   => true,
    ) );
}
add_action( 'after_setup_theme', 'ehome_custom_header_setup' );


// custom-background

function ehome_custom_background_setup() {
    add_theme_support( 'custom-background', array(
        'default-color' => 'ffffff',
    ) );
}
add_action( 'after_setup_theme', 'ehome_custom_background_setup' );



