<?php
/*
Plugin Name: Ehome Core
Plugin URI: https://themeforest.net/user/gramentheme/portfolio
Description: Plugin to contain short codes and custom post types of the Ehome theme.
Author: gramentheme
Author URI: https://ex-coders.com/wp/ehome
Version: 1.0.0
Text Domain: ehome-core
*/


/**
 * If this file is called directly, abort.
 * @package ehome
 * @since 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Plugin directory path
 * @package ehome
 * @since 1.0.0
 */
define( 'EHOME_CORE_ROOT_PATH', plugin_dir_path( __FILE__ ) );
define( 'EHOME_CORE_ROOT_URL', plugin_dir_url( __FILE__ ) );
define( 'EHOME_CORE_SELF_PATH', 'ehome-core/ehome-core.php' );
define( 'EHOME_CORE_VERSION', '1.0.0' );
define( 'EHOME_CORE_INC', EHOME_CORE_ROOT_PATH .'/inc');
define( 'EHOME_CORE_LIB', EHOME_CORE_ROOT_PATH .'/lib');
define( 'EHOME_CORE_ELEMENTOR', EHOME_CORE_ROOT_PATH .'/elementor');
define( 'EHOME_CORE_DEMO_IMPORT', EHOME_CORE_ROOT_PATH .'/demo-import');
define( 'EHOME_CORE_ADMIN', EHOME_CORE_ROOT_PATH .'/admin');
define( 'EHOME_CORE_ADMIN_ASSETS', EHOME_CORE_ROOT_URL .'admin/assets');
define( 'EHOME_CORE_WP_WIDGETS', EHOME_CORE_ROOT_PATH .'/wp-widgets');
define( 'EHOME_CORE_ASSETS', EHOME_CORE_ROOT_URL .'assets/');
define( 'EHOME_CORE_CSS', EHOME_CORE_ASSETS .'css');
define( 'EHOME_CORE_JS', EHOME_CORE_ASSETS .'js');
define( 'EHOME_CORE_IMG', EHOME_CORE_ASSETS .'img');


/**
 * Load additional helpers functions
 * @package ehome
 * @since 1.0.0
 */
if (!function_exists('ehome_core')){
	require_once EHOME_CORE_INC .'/theme-core-helper-functions.php';
	if (!function_exists('ehome_core')){
		function ehome_core(){
			return class_exists('Ehome_Core_Helper_Functions') ? new Ehome_Core_Helper_Functions() : false;
		}
	}
}
//ob flash
remove_action( 'shutdown', 'wp_ob_end_flush_all', 1 );


/**
 * Load Codestar Framework Functions
 * @package ehome
 * @since 1.0.0
 */
if ( !ehome_core()->is_ehome_active()) {
	if ( file_exists( EHOME_CORE_ROOT_PATH . '/inc/csf-functions.php' ) ) {
		require_once EHOME_CORE_ROOT_PATH . '/inc/csf-functions.php';
	}
}



/**
 * Core Plugin Init
 * @package ehome
 * @since 1.0.0
 */
if ( file_exists( EHOME_CORE_ROOT_PATH . '/inc/theme-core-init.php' ) ) {
	require_once EHOME_CORE_ROOT_PATH . '/inc/theme-core-init.php';
}